/*
Created by: Prateek Rungta http://prateekrungta.com/livescorewidget
*/

var thingy;	//holds a DOM object
var fadedObjects = new Array();	//holds the DOM ojects currently being faded
var currentAnimator;	//holds an AppleAnimator object
var currentMatch = null;	//holds the matchId of the match on display


function addCountryFlag (elementId, countryId, opacity) 
{
	// gets the country's cricket board's logo's filename and 
	// puts it as an img in elementId
	var thingy = document.getElementById(elementId);
	var imgSrc = null;
	switch (countryId) {
		case 1  : imgSrc = 'England'; break;
		case 2	: imgSrc = 'Australia'; break;
		case 3  : imgSrc = 'SAfrica'; break;
		case 4  : imgSrc = 'WIndies'; break;
		case 5  : imgSrc = 'NZealand'; break;
		case 6  : imgSrc = 'India'; break;
		case 7  : imgSrc = 'Pakistan'; break;
		case 8  : imgSrc = 'SLanka'; break;
		case 9  : imgSrc = 'Zimbabwe'; break;
		case 12	: imgSrc = 'Bermudas'; break;
		case 15 : imgSrc = 'Netherlands'; break;
		case 17	: imgSrc = 'Canada'; break;
		case 25 : imgSrc = 'Bangladesh'; break;
		case 26	: imgSrc = 'Kenya'; break;
		case 29 : imgSrc = 'Ireland'; break;
		case 30	: imgSrc = 'Scotland'; break;
	}
	imgSrc += ".gif";
	imgSrc = "Images/" + imgSrc;
	var countryFlag = document.createElement('img');
	countryFlag.setAttribute("src", imgSrc);
	countryFlag.setAttribute("width", "124");
	//countryFlag.setAttribute("height", "120");
	while (thingy.hasChildNodes()) {
			thingy.removeChild(thingy.firstChild);
		}
	if (!opacity) opacity = 0.10;
	thingy.style.opacity = opacity;
	thingy.appendChild(countryFlag);
}

function clearMatchInfo()
{
	var thingy = document.getElementById('matchInfo');
	if (thingy) {
		for ( var i = thingy.childNodes.length; i--; ) {
			if (thingy.childNodes[i].nodeName != "div") {
				thingy.childNodes[i].innerText = "";
			}
		}
	}
	thingy = document.getElementById('matchName');
	thingy.innerText = "";
}

function CreateNum(textID, spec)
{
	// to override the CreateText function which treats 0 as null
	var text = spec.text;
	if (window.getLocalizedString) text = getLocalizedString(text);

	document.getElementById(textID).innerText = text; 
}

function showMatchInfo(matchInfo)
{
	/* if match info currently visible, fades it out,
		loads the information from matchInfo and fades
		it in.
	*/
	thingy = document.getElementById('matchInfo');
	if (thingy.style.display == "block" && thingy.style.opacity == "1") {
		fadeOut(thingy, function () { showMatchInfo(matchInfo); } );
	} else {
	
		clearMatchInfo();
		// Displaying current match info
		CreateText('matchName', { text: matchInfo.matchName });
		if (matchInfo.matchId != "error") {
			// Filling the standard stuff
			var batting = matchInfo.battingTeam;
			var bowling = matchInfo.bowlingTeam;
			CreateText('matchStatus', { text: matchInfo.status });
			CreateText('matchVenue', { text: matchInfo.venue });
			if(matchInfo.matchId == "nextmatch") {
				// Next match specific info
				CreateText('nextMatchTeam1', { text: matchInfo.teams[batting].name });
				CreateText('nextMatchVs', { text: "vs." });
				CreateText('nextMatchTeam2', { text: matchInfo.teams[bowling].name });
				addCountryFlag('battingTeamFlag', matchInfo.teams[batting].id, 0.20);
				addCountryFlag('bowlingTeamFlag', matchInfo.teams[bowling].id, 0.20);
			} else {
				// Ongoing match specific info
				CreateText('battingTeamName', { text: matchInfo.teams[batting].name });
				CreateText('bowlingTeamName', { text: matchInfo.teams[bowling].name });
				addCountryFlag('battingTeamFlag', matchInfo.teams[batting].id);
				addCountryFlag('bowlingTeamFlag', matchInfo.teams[bowling].id); 
				CreateText('battingTeamScore', { text: matchInfo.teams[batting].score });
				CreateText('runRate', { text: "Rate " + matchInfo.teams[batting].runRate });
				CreateText('overs', { text: matchInfo.teams[batting].overs + " overs" });
				CreateText('extras', { text: "Extras " + matchInfo.teams[batting].extras });
				if (matchInfo.teams[bowling].score != "") {
					CreateText('bowlingTeamScore', { text: matchInfo.teams[bowling].score });
				} else {
					CreateText('notBatted', { text: "Still to Bat" });
				}
				// The batsmen at the crease
				if (matchInfo.teams[batting].batsmen) {
					// Show the batScore titles
					CreateText("foursTitle", { text: "4" });
					CreateText("sixesTitle", { text: "6" });
					for (var i = 0; i < matchInfo.teams[batting].batsmen.length; i++) {
						var batNo = i + 1;
						var batsman = matchInfo.teams[batting].batsmen[i];
						CreateText("batsman" + batNo, { text: batsman.lastname });
						CreateNum("batsman" + batNo + "runs", 
								{ text: batsman.runs + " (" + batsman.balls + ")" });
						CreateNum("batsman" + batNo + "fours", { text: batsman.fours });
						CreateNum("batsman" + batNo + "sixes", { text: batsman.sixes });
					}
				}
				// The bowlers in their current spell
				if (matchInfo.teams[bowling].bowlers) {
					// Show the bowlStats titles
					CreateText("oversTitle", { text: "O" });
					CreateText("maidensTitle", { text: "M" });
					CreateText("runsTitle", { text: "R" });
					CreateText("wicketsTitle", { text: "W" });
					for (var i = 0; i < matchInfo.teams[bowling].bowlers.length; i++) {
						var bowlNo = i + 1;
						var bowler = matchInfo.teams[bowling].bowlers[i];
						CreateText("bowler" + bowlNo, { text: bowler.lastname });
						CreateNum("bowler" + bowlNo + "overs", { text: bowler.overs });
						CreateNum("bowler" + bowlNo + "runs", { text: bowler.runs });
						CreateNum("bowler" + bowlNo + "maidens", { text: bowler.maidens });
						CreateNum("bowler" + bowlNo + "wickets", { text: bowler.wickets });
					}
				}
			}
		} else {
			CreateText( "errorMessage", { text: matchInfo.errorMessage });
			showElement("refreshButton");
			// forcing check for an update everytime there is an error
			getLatestVersion();
		}
		fadeIn(thingy);
	}
}

function fadeOut(thingy, oncomplete)
{
	currentAnimator = new AppleAnimator(750, 30, 100, 0, fadeHandler);
	if (oncomplete) { currentAnimator.oncomplete = oncomplete; }
	fadedObjects.push(thingy);
	fadedObjects.push(document.getElementById('matchName'));
	currentAnimator.start();
}

function fadeIn(thingy)
{
	var matchName = document.getElementById('matchName');
	matchName.style.opacity = 0.0;
	thingy.style.opacity = 0.0;
	thingy.style.display = "block";
	currentAnimator = new AppleAnimator(750, 30, 0, 100, fadeHandler);
	fadedObjects.push(thingy);
	fadedObjects.push(matchName);
	currentAnimator.start();
}

function fadeHandler(animation, current, start, finish)
{
	// handles the fade animation by setting the opacity to current
	for (var i = fadedObjects.length; i--; ) {
		fadedObjects[i].style.opacity = (current / 100);
	}
	if (finish)	fadedObjects = new Array();
}

function findMatchIndex(matchId)
{
	for (var i=0; i < matches.length && matchId; i++)
		if (matches[i].matchId == matchId)
			return i;
	return -1;
}

function showMatch()
{
	/* shows the updated version of the match on display
		and if no match on display then shows the first
		available match
	*/

	var activeMatch = findMatchIndex(currentMatch);
	if (activeMatch == -1) {
		currentMatch = matches[0].matchId;
		activeMatch = 0;
	}
	showMatchInfo(matches[activeMatch]);
	if (activeMatch > 0) {
		showElement("backButton");
	} else {
		hideElement("backButton");
	}
	if (activeMatch < matches.length - 1) {
		showElement("forwardButton");
	} else {
		hideElement("forwardButton");
	}
}

function showUpdateSlider()
{
	var sliderDiv = document.getElementById('updateSliderDiv');
	var slider = document.getElementById('updateSlider');
	slider.style.top = "-70px";
	var slideAnimator = new AppleAnimator(750, 30, 0, 70, slideHandler);
	slideAnimator.start();
}

function hideUpdateSlider()
{
	var sliderDiv = document.getElementById('updateSliderDiv');
	var slider = document.getElementById('updateSlider');
	slider.style.top = "0px";
	var slideAnimator = new AppleAnimator(600, 30, 70, 0, slideHandler);
	slideAnimator.start();
}

function slideHandler(animation, current, start, finish)
{
	var slider = document.getElementById('updateSlider');
	current = current - 70;
	slider.style.top = current + "px";
}